﻿using System.Drawing;
using System.Windows.Forms;
using System.Reflection;
using Spectral1.DATA_ACCESS;

namespace Spectral1.SPECTRUM_ANALYSER
{
    public partial class UC_spectrum_analysis : UserControl
    {

        #region "===================== DECLARATIONS ============================="
        const int plot_margin = 20;
        Point[] _spectrum_analysis_polyline;
        Brush column_brush = new SolidBrush(Color.SpringGreen);
        Font label_font = new Font("Segoe UI", 6);
        Brush label_brush = new SolidBrush(Color.Yellow);
        Pen axis_pen = new Pen(Color.Yellow);
        double x_step = 1;
        #endregion

        #region "===================== EVENTS ============================="
        private void panel1_Paint(object sender, PaintEventArgs e)
        {
            if (_spectrum_analysis_polyline == null) return;

            e.Graphics.FillPolygon(column_brush, _spectrum_analysis_polyline);

            int y = panel1.ClientRectangle.Height - c_spectrum_analyser.horiz_axis_y_offset;
            e.Graphics.DrawLine(axis_pen, 0, y, panel1.ClientRectangle.Width, y);

            for (int i = 0; i < DA_Spectral.max_harmonics; i++)
            {
                int x = (int)(((double)i * x_step) +  plot_margin); ;
                e.Graphics.DrawString(i.ToString(), label_font, label_brush, x -2, y + 5);
                e.Graphics.DrawLine(axis_pen, x + 3, y + 5, x + 3, y);
            }
            e.Graphics.DrawString("Harmonics", label_font, label_brush, (panel1.ClientRectangle.Width/2) - 10, y + 20);
        }
        #endregion

        #region "===================== METHODS ============================="
        public UC_spectrum_analysis()
        {
            InitializeComponent();

            typeof(Panel).InvokeMember("DoubleBuffered", BindingFlags.SetProperty
            | BindingFlags.Instance | BindingFlags.NonPublic, null,
            panel1, new object[] { true });
        }

        public void refresh_spectrum_analysis_polyline(Point[] spectrum_analysis_polyline)
        {
             x_step = (panel1.ClientRectangle.Width - (2 * plot_margin)) / (double)DA_Spectral.max_harmonics;
            _spectrum_analysis_polyline = spectrum_analysis_polyline;
            this.Refresh();
        }
        #endregion


    }
}
